﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KursBeispiele
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            //Ein Event Manuell hinzufügen - ziemlich straight forward
            textBox1.TextChanged += new EventHandler(textBox1_TextChanged);
        }

        //Diese Ereignisse wurde vom Designer erstellt
        //Bemerkenswertes:
        //- Der eigentliche Code wurde in der ausgelagerten Datei hinzugefügt
        //- Er ist in Form1.Designer.cs erhältlich
        //- Das Ereignis kann daher im Designer betrachtet und gelöscht werden
        private void Form1_MouseClick(object sender, MouseEventArgs e)
        {
            textBox1.Text = e.Location.ToString();
        }

        //Geht nicht wie beim Formular - da das KeyEvent nur an das Control mit
        //Focus gesendet wird - daher setzen wir das Event direkt auf eine TextBox,
        //welche im Gegensatz zum Formular direkt Eingabefokus erhalten kann
        //( Im Prinzip wäre Eingabefokus am Formular auch möglich - aber das ist eine
        //  fortgeschrittenere Technik )
        private void textBox2_KeyDown(object sender, KeyEventArgs e)
        {
            textBox2.Text = e.KeyData.ToString();
        }

        //Dieses Ereignis wurde per Hand erstellt
        //Bemerkenswertes:
        //- Der eigentliche Code befindet sich in diesem Dokument
        //- Das Ereignis kann nicht im Designer betrachtet und gelöscht werden
        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            toolStripStatusLabel1.Text = textBox1.Text;
        }

        //Zeigt die MessageBox an
        private void button1_Click(object sender, EventArgs e)
        {
            //Werte wieder aus ComboBox auslesen
            TypeConverter butConv = TypeDescriptor.GetConverter(typeof(MessageBoxButtons));
            MessageBoxButtons button = (MessageBoxButtons)butConv.ConvertFromString(comboBox2.SelectedItem.ToString());
            TypeConverter iconConv = TypeDescriptor.GetConverter(typeof(MessageBoxIcon));
            MessageBoxIcon icon = (MessageBoxIcon)iconConv.ConvertFromString(comboBox1.SelectedItem.ToString());
            //MessageBox starten - die MessageBox ist ein modaler Dialog
            DialogResult dr = MessageBox.Show("Dies ist eine (Beispiels)messagebox.", "BEISPIEL", button, icon);
            //DialogResult in TextBox schreiben - es wird auf das Beenden der MessageBox gewartet (MODAL!)
            textBox3.Text = dr.ToString();
        }

        //Lädt die ComboBox Listen für die MessageBox
        private void Form1_Load(object sender, EventArgs e)
        {
            //Aus Enumeration Werte holen
            string[] buttons = Enum.GetNames(typeof(MessageBoxButtons));
            string[] icons = Enum.GetNames(typeof(MessageBoxIcon));
            comboBox1.Items.AddRange(icons);
            comboBox2.Items.AddRange(buttons);
            //Den Startwert setzen
            comboBox1.SelectedIndex = comboBox2.SelectedIndex = 0;
        }
    }
}
